(*| 10:29 17/09/1990 *)

{*******************************************************}
{                                                       }
{       Turbo Pascal Version 5.5                        }
{       Window Interface Unit                           }
{                                                       }
{       Copyright (C) 1989 Borland International        }
{                                                       }
{*******************************************************}

unit EGAVideo;

{$S-}

interface

uses Crt;

PROCEDURE WriteStr(Screen, Line, Row: Integer; S: String; Attr: Byte);

PROCEDURE WriteChar(Screen, Line, Row: Integer; Count: Byte; C: Char; Attr: Byte);

PROCEDURE FillWin(Screen: Integer; C: Char; Attr: Byte);

PROCEDURE SelectPage(Screen,Page: Integer);

PROCEDURE ShowPage(Screen,Page: Integer);

PROCEDURE CopyPage(Screen,FrPage,ToPage: Integer);

PROCEDURE SelectFont(Screen,Font: Integer);

PROCEDURE WriteAttrStr(Screen, Line, Row: Integer; S: String);

PROCEDURE ToGraphics(Screen,Attr: Integer);

PROCEDURE ToText(Screen,Attr: Integer);

implementation

USES Dos;

CONST
  DOSI_VIDEO=$10;

PROCEDURE WriteStr(Screen, Line, Row: Integer; S: String; Attr: Byte);
VAR
  Regs: Registers;
BEGIN
  WITH Regs DO BEGIN
    AX:=$2003;
    BH:=Screen;
    BL:=Attr;
    CH:=Line;
    CL:=Row;
    ES:=Seg(S);
    BP:=Ofs(S);
  END;
  Intr(DOSI_VIDEO,Regs);
END;  { WriteStr }

PROCEDURE WriteChar(Screen, Line, Row: Integer; Count: Byte; C: Char; Attr: Byte);
VAR
  Regs: Registers;
BEGIN
  WITH Regs DO BEGIN
    AX:=$2004;
    BH:=Screen;
    BL:=Attr;
    CH:=Line;
    CL:=Row;
    DH:=ORD(C);
    DL:=Count;
  END;
  Intr(DOSI_VIDEO,Regs);
END;  { WriteChar }

PROCEDURE FillWin(Screen: Integer; C: Char; Attr: Byte);
VAR
  Regs: Registers;
BEGIN
  WITH Regs DO BEGIN
    AX:=$2005;
    BH:=Screen;
    BL:=Attr;
    DH:=ORD(C);
  END;
  Intr(DOSI_VIDEO,Regs);
END;  { FillWin }

PROCEDURE SelectPage(Screen,Page: Integer);
VAR
  Regs: Registers;
BEGIN
  WITH Regs DO BEGIN
    AX:=$2006;
    BH:=Screen;
    BL:=Page;
  END;
  Intr(DOSI_VIDEO,Regs);
END;  { SelectPage }

PROCEDURE ShowPage(Screen,Page: Integer);
VAR
  Regs: Registers;
BEGIN
  WITH Regs DO BEGIN
    AX:=$2007;
    BH:=Screen;
    BL:=Page;
  END;
  Intr(DOSI_VIDEO,Regs);
END;  { ShowPage }

PROCEDURE CopyPage(Screen,FrPage,ToPage: Integer);
VAR
  Regs: Registers;
BEGIN
  WITH Regs DO BEGIN
    AX:=$2008;
    BH:=Screen;
    BL:=ToPage;
    CL:=FrPage;
  END;
  Intr(DOSI_VIDEO,Regs);
END;  { CopyPage }

PROCEDURE WriteWin(Screen: Integer; var Buf);
VAR
  Regs: Registers;
BEGIN
  WITH Regs DO BEGIN
    AX:=$200A;
    BH:=Screen;
    ES:=Seg(Buf);
    BP:=Ofs(Buf);
  END;
  Intr(DOSI_VIDEO,Regs);
END;  { WriteWin }

PROCEDURE ReadWin(Screen: Integer; var Buf);
VAR
  Regs: Registers;
BEGIN
  WITH Regs DO BEGIN
    AX:=$2009;
    BH:=Screen;
    ES:=Seg(Buf);
    BP:=Ofs(Buf);
  END;
  Intr(DOSI_VIDEO,Regs);
END;  { ReadWin }

PROCEDURE SelectFont(Screen,Font: Integer);
VAR
  Regs: Registers;
BEGIN
  WITH Regs DO BEGIN
    AX:=$200B;
    BH:=Screen;
    BL:=Font;
  END;
  Intr(DOSI_VIDEO,Regs);
END;  { SelectFont }

PROCEDURE WriteAttrStr(Screen, Line, Row: Integer; S: String);
VAR
  Regs: Registers;
BEGIN
  WITH Regs DO BEGIN
    AX:=$200C;
    BH:=Screen;
    CH:=Line;
    CL:=Row;
    ES:=Seg(S);
    BP:=Ofs(S);
  END;
  Intr(DOSI_VIDEO,Regs);
END;  { WriteAttrStr }

PROCEDURE ToGraphics(Screen,Attr: Integer);
VAR
  Regs: Registers;
BEGIN
  WITH Regs DO BEGIN
    AX:=$200D;
    BH:=Screen;
    BL:=Attr;
  END;
  Intr(DOSI_VIDEO,Regs);
END;  { ToGraphics }

PROCEDURE ToText(Screen,Attr: Integer);
VAR
  Regs: Registers;
BEGIN
  WITH Regs DO BEGIN
    AX:=$200E;
    BH:=Screen;
    BL:=Attr;
  END;
  Intr(DOSI_VIDEO,Regs);
END;  { ToText }

end.
